<?php

namespace Bongo\User\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\User\Models\User;

class UserImpersonationController extends AbstractController
{
    public function start(User $user)
    {
        // Make sure they are not trying to impersonate an administrator
        if (! $user->isDeveloper()) {
            user()->startImpersonating($user);

            return redirect()
                ->to(config('settings.backend_prefix'))
                ->success('You are now impersonating '.$user->name);
        }

        return redirect()->back()->error('Impersonate disabled for this user.');
    }

    public function stop()
    {
        user()->stopImpersonating();

        return redirect()
            ->route('backend.user.index')
            ->success('You are no longer impersonating');
    }
}
