<?php

namespace Bongo\User\Mailables;

use Bongo\User\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ResetPasswordMailable extends Mailable implements ShouldQueue
{
    use Queueable;
    use SerializesModels;

    public string $token;

    protected User $user;

    public function __construct(User $user, $token)
    {
        $this->user = $user;
        $this->token = $token;
    }

    public function build()
    {
        return $this
            ->from(
                config("settings.mail_from_address"),
                config("settings.mail_from_name")
            )
            ->to($this->user->email)
            ->subject('Reset Password Notification')
            ->view('user::mail.reset_password', ['user' => $this->user, 'token' => $this->token])
            ->text('user::mail.reset_password_plain', ['user' => $this->user, 'token' => $this->token]);
    }
}
