<?php

use Bongo\User\Models\User;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    public function up()
    {
        if (! Schema::hasTable('users')) {
            Schema::create('users', function (Blueprint $table) {

                // Primary
                $table->increments('id');
                $table->uuid()->index();

                // Contact fields
                $table->string('first_name')->nullable();
                $table->string('last_name')->nullable();
                $table->string('telephone')->nullable();
                $table->string('mobile')->nullable();

                // Security fields
                $table->string('email')->index();
                $table->string('password');
                $table->rememberToken();

                // Status & Type
                $table->enum('status', [User::PENDING, User::ACTIVE, User::INACTIVE])
                    ->default(User::ACTIVE);

                $table->enum('type', [User::DEVELOPER, User::MANAGER, User::EMPLOYEE])
                    ->default(User::EMPLOYEE);

                // Audit
                $table->unsignedInteger('created_by')->nullable()->index();
                $table->unsignedInteger('updated_by')->nullable()->index();
                $table->unsignedInteger('deleted_by')->nullable()->index();

                $table->timestamp('email_verified_at')->nullable();
                $table->timestamps();
                $table->softDeletes();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('users');
    }
}
