<?php

namespace Bongo\User\Notifications;

use Bongo\User\Mailables\ResetPasswordMailable;
use Bongo\User\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Notification;

class ResetPasswordNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public string $token;

    protected User $user;

    public function __construct(User $user, $token)
    {
        $this->user = $user;
        $this->token = $token;
    }

    public function via($notifiable): array
    {
        return ['mail'];
    }

    public function toMail($notifiable): ResetPasswordMailable
    {
        return new ResetPasswordMailable($this->user, $this->token);
    }
}
