<?php

namespace Bongo\User\Traits;

use Illuminate\Support\Facades\Auth;

trait HasImpersonate
{
    public function startImpersonating($user): void
    {
        session()->put('impersonator', user());
        session()->put('impersonating', $user);
        Auth::loginUsingId($user->id);
    }

    public function stopImpersonating(): void
    {
        if (session()->has('impersonator')) {
            Auth::loginUsingId(session()->get('impersonator')->id);
        }
        session()->forget('impersonator');
        session()->forget('impersonating');
    }

    public function isImpersonating(): bool
    {
        return session()->has('impersonating');
    }
}
