<?php

namespace Bongo\User\Traits;

trait HasName
{
    public function initializeHasName(): void
    {
        $this->append('name');
        $this->mergeFillable(['name']);
    }

    public function getNameAttribute(): false|string
    {
        return ! empty($this->first_name) && ! empty($this->last_name)
            ? $this->first_name.' '.$this->last_name
            : strtok($this->email, '@');
    }

    public function setNameAttribute($value): void
    {
        if (! empty($value)) {
            $splitName = explode(' ', $value);

            $this->attributes['first_name'] = $splitName[0] ?? null;
            $this->attributes['last_name'] = $splitName[1] ?? null;
        }
    }
}
