<?php

namespace Bongo\User\Traits;

trait HasType
{
    public function scopeDeveloper($query)
    {
        return $query->where('type', self::DEVELOPER);
    }

    public function scopeNotDeveloper($query)
    {
        return $query->where('type', '!=', self::DEVELOPER);
    }

    public function scopeManager($query)
    {
        return $query->where('type', self::MANAGER);
    }

    public function scopeNotManager($query)
    {
        return $query->where('type', '!=', self::MANAGER);
    }

    public function scopeEmployee($query)
    {
        return $query->where('type', self::EMPLOYEE);
    }

    public function scopeNotEmployee($query)
    {
        return $query->where('type', '!=', self::EMPLOYEE);
    }

    public function isDeveloper(): bool
    {
        return $this->type === self::DEVELOPER;
    }

    public function isEmployee(): bool
    {
        return $this->type === self::EMPLOYEE;
    }

    public function isManager(): bool
    {
        return $this->type === self::MANAGER;
    }
}
