<?php

namespace Bongo\User;

use Bongo\Framework\Providers\AbstractServiceProvider;
use Bongo\User\Commands\ResetPasswordCommand;
use Bongo\User\Events\UserEventHandler;
use Bongo\User\Http\Middleware\Developer;
use Bongo\User\Http\Middleware\Employee;
use Bongo\User\Http\Middleware\Manager;
use Bongo\User\Http\ViewComposers\UserComposer;
use Bongo\User\Models\User;
use Illuminate\Foundation\AliasLoader;

class UserServiceProvider extends AbstractServiceProvider
{
    protected string $module = 'user';

    protected array $composers = [
        UserComposer::class => [
            'user::backend.partials.dropdowns.users',
        ],
    ];

    protected array $commands = [
        ResetPasswordCommand::class,
    ];

    protected array $middlewares = [
        'developer' => Developer::class,
        'manager' => Manager::class,
        'employee' => Employee::class,
    ];

    protected array $subscribers = [
        UserEventHandler::class,
    ];

    public function boot(): void
    {
        parent::boot();
        AliasLoader::getInstance()->alias('User', User::class);
    }
}
