@extends('framework::auth.layouts.app')

@section('heading')
    {{ session()->has('password_expired') ? trans('user::frontend.expired_title') : trans('user::frontend.reset_title') }}
@endsection

@section('sub_heading')
    <p class="text-center text-gray-600">
        @if (session()->has('password_expired'))
            <strong>{{ trans('user::frontend.expired_sub_heading') }}</strong><br/><br/>
            {{ trans('user::frontend.expired_message') }}<br/><br/>
        @endif
        {{ trans('user::frontend.reset_sub_heading') }}.
    </p>
@endsection

@section('content')
    <form method="POST" action="{{ route('password.email') }}">
        {{ csrf_field() }}

        @input([
        'label' => trans('user::frontend.email'),
        'name' => 'email',
        'placeholder' => 'name@address.com',
        'required' => 'true'
        ])

        @if (! session()->has('password_expired'))
            <div class="mt-6">
                <div class="text-sm leading-5 text-gray-500">
                    {{ trans('user::frontend.remember_password') }}
                    <a href="{{ route('login') }}"
                       class="font-medium text-gray-500 hover:text-gray-700 focus:outline-none focus:underline transition ease-in-out duration-150"
                    >
                        {{ trans('user::frontend.sign_in') }}
                    </a>
                </div>
            </div>
        @endif

        <div class="mt-4">
            <button
                type="submit"
                class="w-full flex justify-center py-3 px-4 border border-transparent text-sm font-medium rounded-sm text-white bg-primary-600 hover:bg-primary-500 focus:outline-none focus:border-primary-700 focus:shadow-outline-primary active:bg-primary-700 transition duration-150 ease-in-out"
            >
                {{ trans('user::frontend.reset_link') }}
            </button>
        </div>
    </form>
@endsection
