@extends('framework::auth.layouts.app')

@section('heading', trans('user::frontend.register_title'))

@section('sub_heading')
    <p class="text-center text-gray-600">
        {{ trans('user::frontend.register_sub_heading') }}
    </p>
@endsection

@section('content')
    <form method="POST" action="{{ route('register') }}">
        {{ csrf_field() }}

        <div class="mt-4">
            @input([
            'label' => trans('user::frontend.full_name'),
            'name' => 'name',
            'placeholder' => 'John Smith',
            'required' => 'true'
            ])
        </div>
        <div class="mt-4">
            @input([
            'label' => trans('user::frontend.email'),
            'name' => 'email',
            'placeholder' => 'name@address.com',
            'required' => 'true'
            ])
        </div>
        <div class="mt-4">
            @select([
            'label' => trans('user::frontend.account_type'),
            'name' => 'category',
            'value' => old('category', null),
            'options' => get_enum_values('users', 'category'),
            ])
        </div>

        <div class="py-8">
            <div class="border-t border-gray-200"></div>
        </div>

        <p class="text-xs text-gray-400">
            {{ trans('user::frontend.password_rules') }}.
        </p>
        <div class="mt-4">
            @input([
            'label' => trans('user::frontend.password'),
            'type' => 'password',
            'name' => 'password',
            'placeholder' => 'Enter your password',
            'required' => 'true'
            ])
        </div>
        <div class="mt-4">
            @input([
            'label' => trans('user::frontend.password_confirm'),
            'type' => 'password',
            'name' => 'password_confirmation',
            'placeholder' => 'Confirm your password',
            'required' => 'true'
            ])
        </div>

        <div class="mt-4">
            <button
                type="submit"
                class="w-full flex justify-center py-3 px-4 border border-transparent text-sm font-medium rounded-sm text-white bg-primary-600 hover:bg-primary-500 focus:outline-none focus:border-primary-700 focus:shadow-outline-primary active:bg-primary-700 transition duration-150 ease-in-out"
            >
                {{ trans('user::frontend.sign_up') }}
            </button>
        </div>

        <div class="mt-4 text-center text-muted text-gray-500">
            {{ trans('user::frontend.have_account') }}
            <a href="{{ route('login') }}"
               class="font-medium text-gray-500 hover:text-gray-700 focus:outline-none focus:underline transition ease-in-out duration-150"
            >
                {{ trans('user::frontend.sign_in') }}
            </a>
        </div>
    </form>
@endsection
