@extends('framework::auth.layouts.app')

@section('heading', trans('user::frontend.new_password_title'))

@section('sub_heading')
    <p class="text-center text-gray-600">
        {{ trans('user::frontend.new_password_sub_heading') }}
    </p>
@endsection

@section('content')
    <form method="POST" action="{{ route('password.store') }}">
        {{ csrf_field() }}
        <input type="hidden" name="token" value="{{ $request->route('token') }}">

        @input([
            'label' => trans('user::frontend.email'),
            'type' => 'email',
            'name' => 'email',
            'required' => 'true',
            'value' => $request->email
        ])

        <p class="mt-4 text-xs text-gray-400">
            {{ trans('user::frontend.password_rules') }}.
        </p>

        <div class="mt-4 sm:border-t sm:border-gray-200 sm:pt-5">
            @input([
                'label' => trans('user::frontend.password'),
                'type' => 'password',
                'name' => 'password',
                'required' => 'true'
            ])
        </div>

        <div class="mt-4">
            @input([
                'label' => trans('user::frontend.password_confirm'),
                'type' => 'password',
                'name' => 'password_confirmation',
                'required' => 'true'
            ])
        </div>

        <div class="mt-6">
            <div class="text-sm leading-5 text-gray-500">
                {{ trans('user::frontend.remember_password') }}
                <a href="{{ route('login') }}"
                   class="font-medium text-gray-500 hover:text-gray-700 focus:outline-none focus:underline transition ease-in-out duration-150"
                >
                    {{ trans('user::frontend.sign_in') }}
                </a>
            </div>
        </div>

        <div class="mt-6">
            <button
                type="submit"
                class="w-full flex justify-center py-3 px-4 border border-transparent text-sm font-medium rounded-sm text-white bg-primary-600 hover:bg-primary-500 focus:outline-none focus:border-primary-700 focus:shadow-outline-primary active:bg-primary-700 transition duration-150 ease-in-out"
            >
                {{ trans('user::frontend.reset_password') }}
            </button>
        </div>
    </form>
@endsection
