@extends('framework::backend.layouts.app')

@section('content')
    @component('blade::content_header')
        {{ trans('user::backend.index') }}
        @slot('actions')
            @backButton(['name' => trans('dashboard::backend.index')])
            @createButton(['permission' => 'user.create', 'name' => trans('user::backend.create'), 'url' => route('backend.user.create')])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <data-table
            search-url="{{ route('backend.user.datatable') }}"
            resource-url="{{ route('backend.user.index') }}"
            order-by="first_name"
            order-direction="asc"
            v-cloak
        >
            <template slot="custom-filters" slot-scope="{updateFilters, getFilterValue}">
                <data-table-filter :first-child="true">
                    <select class="form-input w-full block rounded-sm pr-10 sm:text-sm sm:leading-5"
                            :value="getFilterValue('status')"
                            @change="event => updateFilters(event, 'status')"
                    >
                        <option value="">All Statuses</option>
                        <option value="pending">Pending</option>
                        <option value="active">Active</option>
                        <option value="inactive">Inactive</option>
                    </select>
                    <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-500">
                        <svg class="fill-current h-4 w-6" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                            <path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z"/>
                        </svg>
                    </div>
                </data-table-filter>
            </template>

            <template slot="default" slot-scope="{items, itemIndex, isSelected, setAsSelectedItem, viewUrl, editUrl}">
                <div class="grid md:grid-cols-2 gap-3">

                    <v-card
                        v-for="(item, index) in items"
                        :key="item.id"
                        :id="itemIndex(item, index)"
                        :class="['col-span-1', { selected : isSelected(item, index) }]"
                        @click="setAsSelectedItem(item, index)"
                    >
                        <template slot="left">
                            <div class="md:flex items-center">
                                <div class="mb-2 mr-3 lg:mb-0">
                                    <a :href="viewUrl(item)"
                                       class="flex m-0 md:m-auto lg:m-0 items-end h-14 w-14 rounded-full border-2 border-gray-200 bg-gray-100 hover:bg-gray-200"
                                    >
                                        <img :src="item.avatar" alt="avatar"
                                             class="h-14 w-14 inline-block rounded-full"
                                        >
                                    </a>
                                </div>
                                <div class="text-left">
                                    <a :href="viewUrl(item)" title="View"
                                       class="block font-semibold hover:text-primary-500 focus:text-primary-600"
                                    >
                                        @{{ item.name }}
                                    </a>
                                    <div v-if="item.status || item.type">
                                        <span class="text-sm">
                                            @{{ item.type | ucwords }}
                                        </span>
                                        &nbsp;<span class="text-xs text-gray-400">|</span>&nbsp;
                                        <span
                                            :class="['text-sm', item.status === 'active' ? 'text-green-400' : 'text-red-500']"
                                        >
                                            @{{ item.status | ucwords }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </template>

                        <template slot="right">
                            <div v-if="item.telephone" class="text-sm flex items-center">
                                <svg fill="currentColor" viewBox="0 0 20 20" class="h-4 w-4 mr-1 text-gray-400">
                                    <path
                                        d="M17.924 2.617a.997.997 0 00-.215-.322l-.004-.004A.997.997 0 0017 2h-4a1 1 0 100 2h1.586l-3.293 3.293a1 1 0 001.414 1.414L16 5.414V7a1 1 0 102 0V3a.997.997 0 00-.076-.383z"
                                    ></path>
                                    <path
                                        d="M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l.74 4.435a1 1 0 01-.54 1.06l-1.548.773a11.037 11.037 0 006.105 6.105l.774-1.548a1 1 0 011.059-.54l4.435.74a1 1 0 01.836.986V17a1 1 0 01-1 1h-2C7.82 18 2 12.18 2 5V3z"
                                    ></path>
                                </svg>
                                <a :href="'tel:' + item.telephone" title="Call"
                                   class="text-primary-500 truncate hover:underline hover:text-primary-700"
                                >
                                    @{{ item.telephone }}
                                </a>
                            </div>
                            <div v-if="item.mobile" class="text-sm flex items-center">
                                <svg fill="currentColor" viewBox="0 0 20 20" class="h-4 w-4 mr-1 text-gray-400">
                                    <path
                                        d="M18 5v8a2 2 0 01-2 2h-5l-5 4v-4H4a2 2 0 01-2-2V5a2 2 0 012-2h12a2 2 0 012 2zM7 8H5v2h2V8zm2 0h2v2H9V8zm6 0h-2v2h2V8z"
                                        clip-rule="evenodd" fill-rule="evenodd"
                                    ></path>
                                </svg>
                                <a :href="'tel:' + item.mobile" title="Call"
                                   class="text-primary-500 truncate hover:underline hover:text-primary-700"
                                >
                                    @{{ item.mobile }}
                                </a>
                            </div>
                            <div v-if="item.email" class="text-sm flex items-center">
                                <svg fill="currentColor" viewBox="0 0 20 20" class="h-4 w-4 mr-1 text-gray-400">
                                    <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z"
                                    ></path>
                                    <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"></path>
                                </svg>
                                <a :href="'mailto:' + item.email" title="Email"
                                   class="text-primary-500 truncate hover:underline hover:text-primary-700"
                                >
                                    @{{ item.email }}
                                </a>
                            </div>
                        </template>

                        <template slot="footer">
                            <div class="grid grid-cols-2 gap-2 items-center">
                                <div class="col-span-1">

                                </div>
                                <div class="col-span-1 text-right">
                                    <v-button :link="viewUrl(item)">View</v-button>
                                </div>
                            </div>
                        </template>
                    </v-card>

                </div>
            </template>

        </data-table>
    @endcomponent
@stop
