<?php

namespace Bongo\User\Commands;

use Bongo\User\Models\User;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Hash;

class ResetPasswordCommand extends Command
{
    protected $signature = 'user:reset_password';

    protected $description = 'Resets a users password.';

    public function handle()
    {
        $random = str_shuffle('abcdefghjklmnopqrstuvwxyzABCDEFGHJKLMNOPQRSTUVWXYZ234567890!$%^&!$%^&');
        $randomPassword = substr($random, 0, 32);

        $user = User::where('email', config('developer.email'))->first();
        if (! $user) {
            console_print("Unable to find an account for the given user");

            return;
        }

        $user->password = Hash::make($randomPassword);
        $user->save();

        console_print($randomPassword);
    }
}
