<?php

namespace Bongo\User\Http\Controllers\Api;

use Bongo\Framework\Http\Controllers\AbstractApiController;
use Bongo\User\Models\User;
use Illuminate\Http\JsonResponse;

class UserController extends AbstractApiController
{
    public function index(): JsonResponse
    {
        $query = (new User())->newQuery();
        $input = request()->input();

        if (isset($input['search']) && ! empty($input['search'])) {
            $search_query = strtolower(trim($input['search']));
            $words = explode(' ', $search_query);
            foreach ($words as $word) {
                if (empty($word)) {
                    continue;
                }
                $query->where(function ($q) use ($word) {
                    $q->where('first_name', 'LIKE', "%{$word}%")
                        ->orWhere('last_name', 'LIKE', "%{$word}%");
                });
            }
        }

        return response()->json([
            'results' => $query->orderBy('first_name')->get(),
        ]);
    }
}
