<?php

namespace Bongo\User\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractDatatableController;
use Bongo\User\Http\Resources\UserResource;
use Bongo\User\Models\User;
use Illuminate\Database\Eloquent\Builder;

class UserDatatableController extends AbstractDatatableController
{
    protected User $user;

    public function __construct(User $user)
    {
        $this->user = $user;
    }

    protected function getBaseQuery(): Builder
    {
        return $this->user->select('users.*')->notDeveloper();
    }

    protected function applySearchQuery()
    {
        if (isset($this->input['search']) && ! empty($this->input['search'])) {
            $search_query = strtolower(trim($this->input['search']));

            $words = explode(' ', $search_query);
            foreach ($words as $word) {
                if (empty($word)) {
                    continue;
                }
                $this->query->where(function ($q) use ($word) {
                    $q->where('users.first_name', 'LIKE', "%{$word}%")
                        ->orWhere('users.last_name', 'LIKE', "%{$word}%")
                        ->orWhere('users.email', 'LIKE', "%{$word}%")
                        ->orWhere('users.telephone', 'LIKE', "%{$word}%")
                        ->orWhere('users.mobile', 'LIKE', "%{$word}%");
                });
            }
        }
    }

    protected function setTotalResults()
    {
        $this->totalResults = $this->query->distinct()->get()->count();
    }

    protected function setResults()
    {
        $this->results = UserResource::collection($this->query->distinct()->get());
    }
}
