<?php

namespace Bongo\User\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractController;
use Bongo\Image\Http\Requests\StoreImageRequest;
use Bongo\Image\Services\AvatarImage;
use Bongo\User\Models\User;
use Exception;
use Illuminate\Http\JsonResponse;

class UserImageController extends AbstractController
{
    public function upload(StoreImageRequest $request, User $user): JsonResponse
    {
        $files = request()->file('files');

        try {
            $user = (new AvatarImage($user, $files[0]))->save();

            return response()->json([$user->getAvatar()]);

        } catch (Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}
