<?php

namespace Bongo\User\Http\Middleware;

use Closure;

class Developer
{
    public function handle($request, Closure $next)
    {
        // If the user is not logged in the redirect to login
        if (! user()) {
            return redirect()->to('/login');
        }

        // If they are logged in but not a developer the throw a 404
        if (! user()->isDeveloper()
            && ! request()->is('admin/users/stop-impersonating')
        ) {
            abort(404);
        }

        return $next($request);
    }
}
