<?php

namespace Bongo\User\Http\Middleware;

use Closure;

class Employee
{
    public function handle($request, Closure $next)
    {
        // If the user is not logged in the redirect to login
        if (! user()) {
            return redirect()->to('/login');
        }

        // If they are logged in but not an employee or developer the throw a 404
        if (! user()->isEmployee()
            && ! user()->isManager()
            && ! user()->isDeveloper()
            && ! request()->is('admin/users/stop-impersonating')
        ) {
            abort(404);
        }

        return $next($request);
    }
}
