<?php

namespace Bongo\User\Http\Requests;

use Bongo\User\Models\User;
use Illuminate\Foundation\Http\FormRequest;

class UpdateUserRequest extends FormRequest
{
    public function rules(): array
    {
        $user_table = (new User())->getTable();

        return [
            'first_name' => 'nullable|max:70',
            'last_name' => 'nullable|max:70',
            'telephone' => 'nullable',
            'mobile' => 'nullable',
            'email' => "required|string|email:rfc,dns|unique:{$user_table},email,".$this->user->id.',id,deleted_at,NULL|max:50',
            'password' => 'sometimes|nullable|string|min:8|confirmed|regex:/^(?=.*?[A-Z])(?=.*?[a-z])(?=.*?[0-9])(?=.*?[#?!@$%^&*-]).{6,}$/',
        ];
    }

    public function messages(): array
    {
        return [
            'password.regex' => 'Your password must be more than 8 characters long, should contain at-least 1 Uppercase, 1 Lowercase, 1 Numeric and 1 special character.',
        ];
    }
}
