<?php

namespace Bongo\User\Http\ViewComposers;

use Bongo\User\Models\User;
use Illuminate\Support\Facades\Cache;
use Illuminate\View\View;

class UserComposer
{
    public function compose(View $view): void
    {
        // $view_data = $view->getData();

        // Get the users
        $users = Cache::remember('users', config('settings.cache_default'), function () {
            $users = User::visible()->orderBy('email', 'ASC')->pluck('email', 'id')->toArray();
            if (! $users) {
                $users = [];
            }

            return $users;
        });

        // Pass the data to the view partial
        $view->with(compact('users'));
    }
}
