<?php

namespace Bongo\User\Models;

use Bongo\Framework\Traits\HasStatus;
use Bongo\Framework\Traits\HasUUID;
use Bongo\Image\Traits\HasImages;
use Bongo\User\Notifications\ResetPasswordNotification;
use Bongo\User\Traits\HasAvatar;
use Bongo\User\Traits\HasImpersonate;
use Bongo\User\Traits\HasName;
use Bongo\User\Traits\HasPhone;
use Bongo\User\Traits\HasType;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    public const PENDING = 'pending';
    public const ACTIVE = 'active';
    public const INACTIVE = 'inactive';

    public const DEVELOPER = 'developer';
    public const EMPLOYEE = 'employee';
    public const MANAGER = 'manager';

    use HasAvatar;
    use HasImages;
    use HasImpersonate;
    use HasName;
    use HasPhone;
    use HasStatus;
    use HasApiTokens;
    use HasType;
    use HasUUID;
    use Notifiable;
    use SoftDeletes;

    protected $fillable = [
        'first_name',
        'last_name',
        'telephone',
        'mobile',
        'email',
        'password',
        'type',
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public function sendPasswordResetNotification($token)
    {
        $this->notify(new ResetPasswordNotification($this, $token));
    }
}
