<?php

use Bongo\User\Http\Controllers\Backend\UserController;
use Bongo\User\Http\Controllers\Backend\UserDatatableController;
use Bongo\User\Http\Controllers\Backend\UserImageController;
use Bongo\User\Http\Controllers\Backend\UserImpersonationController;
use Illuminate\Support\Facades\Route;

Route::prefix('users')
    ->middleware('manager')
    ->as('user.')
    ->group(function () {
        Route::get('/', [UserController::class, 'index'])
            ->name('index');

        Route::get('create', [UserController::class, 'create'])
            ->name('create');

        Route::post('store', [UserController::class, 'store'])
            ->name('store');

        Route::get('datatable', [UserDatatableController::class, 'index'])
            ->name('datatable');

        Route::get('stop-impersonating', [UserImpersonationController::class, 'stop'])
            ->name('stop_impersonating');

        // User/{user}/
        Route::prefix('{user}')
            ->group(function () {
                Route::get('/', [UserController::class, 'show'])
                    ->name('show');

                Route::get('edit', [UserController::class, 'edit'])
                    ->name('edit');

                Route::post('update', [UserController::class, 'update'])
                    ->name('update');

                Route::delete('delete', [UserController::class, 'destroy'])
                    ->name('destroy');

                Route::post('image', [UserImageController::class, 'upload'])
                    ->name('image');

                Route::get('start-impersonating', [UserImpersonationController::class, 'start'])
                    ->name('start_impersonating');
            });
    });
