@extends('framework::auth.layouts.app')

@section('heading', trans('user::frontend.login_title'))

@section('content')
    <form method="POST" action="{{ route('login') }}">
        {{ csrf_field() }}

        @input([
        'label' => trans('user::frontend.email'),
        'name' => 'email',
        'required' => 'true'
        ])

        <div class="mt-4">
            @input([
            'label' => trans('user::frontend.password'),
            'type' => 'password',
            'name' => 'password',
            'required' => 'true'
            ])
        </div>

        @if (config('settings.password_reset_enabled'))
            <div class="mt-6 flex items-center justify-between">

                @if (config('settings.password_reset_enabled'))
                    <div class="text-sm leading-5">
                        <a href="{{ route('password.request') }}"
                           dusk="reset-password-button"
                           class="font-medium text-gray-500 hover:text-gray-700 focus:outline-none focus:underline transition ease-in-out duration-150"
                        >
                            {{ trans('user::frontend.forgot_password') }}
                        </a>
                    </div>
                @endif

            </div>
        @endif

        <div class="mt-6">
            <button
                type="submit"
                class="w-full flex justify-center py-3 px-4 border border-transparent text-sm font-medium rounded-sm text-white bg-primary-600 hover:bg-primary-500 focus:outline-none focus:border-primary-700 focus:shadow-outline-primary active:bg-primary-700 transition duration-150 ease-in-out"
                dusk="login-button"
            >
                {{ trans('user::frontend.sign_in') }}
            </button>
        </div>
    </form>
@endsection
