@extends('framework::backend.layouts.app')

@section('content')
    <form method="POST" action="{{ route('backend.user.update', $user) }}">
        {{ csrf_field() }}

        @component('blade::content_header')
            {{ trans('user::backend.edit') }}
            @slot('actions')
                @backButton(['name' => trans('user::backend.index'), 'url' => route('backend.user.show', $user->id)])
                @saveButton(['permission' => 'user.update', 'name' => trans('user::backend.update')])
            @endslot
        @endcomponent

        @component('blade::content_body')
            @include('user::backend.partials.form.details')
        @endcomponent

    </form>
@stop
