@extends('framework::backend.layouts.app')

@section('content')

    @component('blade::content_header')
        {{ $user->email }}
        @slot('actions')
            @if (user()->id !== $user->id && !$user->isDeveloper())
                @linkButton(['name' => 'Login As User','url' => route('backend.user.start_impersonating', $user->id)])
            @endif
            @if (user()->id !== $user->id)
                @deleteButton(['permission' => 'user.delete', 'name' => trans('user::backend.delete'), 'url' => route('backend.user.destroy', $user->id)])
            @endif
            @backButton(['name' => trans('user::backend.index'), 'url' => route('backend.user.index')])
            @editButton(['permission' => 'user.update', 'name' => trans('user::backend.edit'), 'url' => route('backend.user.edit', $user->id)])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <div class="bg-white shadow overflow-hidden sm:rounded-tl-sm sm:rounded-tr-sm">
            <div class="px-4 py-3 sm:px-6">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-2 items-center">

                    <div class="col-span-1 order-1">
                        <div class="flex items-center">
                            <div class="mb-2 mr-3 lg:mb-0">
                                <div
                                    class="flex m-0 items-end rounded-full border-2 border-gray-200 bg-gray-100 h-20 w-20 md:m-auto lg:m-0"
                                >
                                    <img src="{{ $user->getAvatar() }}" alt="User Avatar"
                                         class="h-20 w-20 inline-block rounded-full"
                                    />
                                </div>
                            </div>
                            <div class="text-left">
                                <div class="block font-semibold truncate">
                                    {{ $user->title }} {{ $user->first_name }} {{ $user->last_name }}
                                </div>
                                <div
                                    class="text-sm {{ $user->status === 'Active' ? 'text-green-400' : 'text-red-500' }}"
                                >
                                    {{ ucfirst($user->status) }}
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-span-1 text-left order-3 mb-2 lg:mb-0 lg:text-right lg:order-2">
                        @if(!empty($user->telephone))
                            <div class="text-sm flex items-center">
                                <svg fill="currentColor" viewBox="0 0 20 20" class="h-4 w-4 mr-1 text-gray-400">
                                    <path
                                        d="M17.924 2.617a.997.997 0 00-.215-.322l-.004-.004A.997.997 0 0017 2h-4a1 1 0 100 2h1.586l-3.293 3.293a1 1 0 001.414 1.414L16 5.414V7a1 1 0 102 0V3a.997.997 0 00-.076-.383z"
                                    ></path>
                                    <path
                                        d="M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l.74 4.435a1 1 0 01-.54 1.06l-1.548.773a11.037 11.037 0 006.105 6.105l.774-1.548a1 1 0 011.059-.54l4.435.74a1 1 0 01.836.986V17a1 1 0 01-1 1h-2C7.82 18 2 12.18 2 5V3z"
                                    ></path>
                                </svg>
                                <a href="tel:{{ $user->telephone }}" title="Call"
                                   class="text-primary-500 hover:underline hover:text-primary-700"
                                >
                                    {{ $user->telephone }}
                                </a>
                            </div>
                        @endif
                        @if(!empty($user->mobile))
                            <div class="text-sm flex items-center">
                                <svg fill="currentColor" viewBox="0 0 20 20" class="h-4 w-4 mr-1 text-gray-400">
                                    <path
                                        d="M18 5v8a2 2 0 01-2 2h-5l-5 4v-4H4a2 2 0 01-2-2V5a2 2 0 012-2h12a2 2 0 012 2zM7 8H5v2h2V8zm2 0h2v2H9V8zm6 0h-2v2h2V8z"
                                        clip-rule="evenodd" fill-rule="evenodd"
                                    ></path>
                                </svg>
                                <a href="tel:{{ $user->mobile }}" title="Call"
                                   class="text-primary-500 hover:underline hover:text-primary-700"
                                >
                                    {{ $user->mobile }}
                                </a>
                            </div>
                        @endif
                        @if(!empty($user->email))
                            <div class="text-sm flex items-center">
                                <svg fill="currentColor" viewBox="0 0 20 20" class="h-4 w-4 mr-1 text-gray-400">
                                    <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z"
                                    ></path>
                                    <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"></path>
                                </svg>
                                <a href="mailto:{{ $user->email }}" title="Email"
                                   class="text-primary-500 hover:underline hover:text-primary-700"
                                >
                                    {{ $user->email }}
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <tabs class-list="border-t border-gray-100">
            <tab name="Details" :selected="true">
                @include('user::backend.partials.tab_detail')
            </tab>
        </tabs>

    @endcomponent
@stop
